/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping.id.manager;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.codefilarete.stalactite.engine.runtime.WriteExecutor;
import org.codefilarete.stalactite.mapping.IdAccessor;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.GeneratedKeysReader;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.PairIterator;
import org.codefilarete.tool.exception.Exceptions;

public class JDBCGeneratedKeysIdentifierManager<T, I>
implements IdentifierInsertionManager<T, I> {
    private final Class<I> identifierType;
    private final AfterInsertIdentifierFixer<T, I> identifierFixer;
    private final GeneratedKeysReader generatedKeysReader;

    public JDBCGeneratedKeysIdentifierManager(IdAccessor<T, I> idAccessor, GeneratedKeysReader<I> generatedKeysReader, Class<I> identifierType) {
        this.identifierFixer = new AfterInsertIdentifierFixer(idAccessor);
        this.generatedKeysReader = generatedKeysReader;
        this.identifierType = identifierType;
    }

    @Override
    public Class<I> getIdentifierType() {
        return this.identifierType;
    }

    @Override
    public WriteExecutor.JDBCBatchingIterator<T> buildJDBCBatchingIterator(Iterable<? extends T> entities, WriteOperation<? extends Column<? extends Table, ?>> writeOperation, int batchSize) {
        return new JDBCBatchingIteratorGeneratedKeysAware<T, I>(entities, writeOperation, batchSize, this.generatedKeysReader, this.identifierFixer);
    }

    private static class JDBCBatchingIteratorGeneratedKeysAware<T, I>
    extends WriteExecutor.JDBCBatchingIterator<T> {
        private final GeneratedKeysReader generatedKeysReader;
        private final BiConsumer<T, I> generatedKeysConsumer;
        private final List<T> elementsOfStep;

        public JDBCBatchingIteratorGeneratedKeysAware(Iterable<? extends T> entities, WriteOperation writeOperation, int batchSize, GeneratedKeysReader generatedKeysReader, BiConsumer<T, I> generatedKeysConsumer) {
            super(entities, writeOperation, batchSize);
            this.elementsOfStep = new ArrayList<T>(batchSize);
            this.generatedKeysReader = generatedKeysReader;
            this.generatedKeysConsumer = generatedKeysConsumer;
        }

        public T next() {
            Object next = super.next();
            this.elementsOfStep.add(next);
            return (T)next;
        }

        @Override
        public void onStep() {
            super.onStep();
            try {
                List rows = this.generatedKeysReader.convert(this.getWriteOperation());
                PairIterator pairIterator = new PairIterator(this.elementsOfStep, (Iterable)rows);
                while (pairIterator.hasNext()) {
                    Duo pair = pairIterator.next();
                    this.generatedKeysConsumer.accept(pair.getLeft(), pair.getRight());
                }
                this.elementsOfStep.clear();
            }
            catch (SQLException e) {
                throw Exceptions.asRuntimeException((Throwable)e);
            }
        }
    }

    private static class AfterInsertIdentifierFixer<T, I>
    implements BiConsumer<T, I> {
        private final IdAccessor<T, I> idAccessor;

        private AfterInsertIdentifierFixer(IdAccessor<T, I> idAccessor) {
            this.idAccessor = idAccessor;
        }

        @Override
        public void accept(T t, I id) {
            this.idAccessor.setId(t, id);
        }
    }
}

